/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.util;

import com.yollo.dmlreforged.core.configs.BalanceConfigs;

public class DataModelLevelupHelper {
    private static final int[] killMultiplier = new int[]{(Integer)BalanceConfigs.killMultiplierTier0.get(), (Integer)BalanceConfigs.killMultiplierTier1.get(), (Integer)BalanceConfigs.killMultiplierTier2.get(), (Integer)BalanceConfigs.killMultiplierTier3.get(), 0};
    private static final int[] maxExperience = new int[]{(Integer)BalanceConfigs.killsToTier1.get() * killMultiplier[0], (Integer)BalanceConfigs.killsToTier2.get() * killMultiplier[1], (Integer)BalanceConfigs.killsToTier3.get() * killMultiplier[2], (Integer)BalanceConfigs.killsToTier4.get() * killMultiplier[3]};

    public static boolean shouldIncreaseTier(int tier, int kc, int sc) {
        if (tier == 4) {
            return false;
        }
        int killExperience = kc * killMultiplier[tier];
        int roof = maxExperience[tier];
        return killExperience + sc >= roof;
    }

    public static double getCurrentTierKillCountWithSims(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0.0;
        }
        return (double)kc + (double)sc / (double)killMultiplier[tier];
    }

    public static int getCurrentTierSimulationCountWithKills(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0;
        }
        return sc + kc * killMultiplier[tier];
    }

    public static double getKillsToNextTier(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0.0;
        }
        int killRoof = DataModelLevelupHelper.getTierRoof(tier, true);
        return (double)killRoof - DataModelLevelupHelper.getCurrentTierKillCountWithSims(tier, kc, sc);
    }

    public static int getSimulationsToNextTier(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0;
        }
        int roof = DataModelLevelupHelper.getTierRoof(tier, false);
        return roof - DataModelLevelupHelper.getCurrentTierSimulationCountWithKills(tier, kc, sc);
    }

    public static int getTierRoof(int tier, boolean asKills) {
        if (tier == 4) {
            return 0;
        }
        if (!asKills) {
            return maxExperience[tier];
        }
        return maxExperience[tier] / killMultiplier[tier];
    }

    public static int getKillMultiplier(int tier) {
        return killMultiplier[tier];
    }
}

